import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Create figure and axis
fig, ax = plt.subplots(figsize=(10, 8))

# Define colors for statuses
colors = {
    'clear': 'green',
    'supports': 'red',
    'table': 'blue',
    'hand': 'gray'
}

# Draw the table
table = patches.Rectangle((0.1, 0.05), 0.8, 0.1, linewidth=2, edgecolor='black', facecolor=colors['table'])
ax.add_patch(table)
ax.text(0.5, 0.025, 'Table', ha='center', va='center', fontsize=10, color='white')

# Draw blocks
blocks = {
    'block_a': {'pos': (0.2, 0.15), 'status': 'supports'},
    'block_b': {'pos': (0.5, 0.15), 'status': 'supports'},
    'block_c': {'pos': (0.5, 0.25), 'status': 'clear'},
    'block_d': {'pos': (0.2, 0.25), 'status': 'clear'},
    'block_e': {'pos': (0.8, 0.15), 'status': 'clear'}
}

for block, info in blocks.items():
    rect = patches.Rectangle(info['pos'], 0.1, 0.1, linewidth=2, edgecolor='black', facecolor=colors[info['status']])
    ax.add_patch(rect)
    ax.text(info['pos'][0] + 0.05, info['pos'][1] + 0.05, f'{block}\n({info["status"]})', ha='center', va='center', fontsize=9, color='white')

# Draw the hand
hand = patches.Ellipse((0.9, 0.35), 0.15, 0.08, linewidth=2, edgecolor='black', facecolor=colors['hand'])
ax.add_patch(hand)
ax.text(0.9, 0.35, 'Hand\n(empty)', ha='center', va='center', fontsize=9, color='black')

# Create legend
legend_elements = [
    patches.Patch(facecolor=colors['clear'], edgecolor='black', label='Clear'),
    patches.Patch(facecolor=colors['supports'], edgecolor='black', label='Supports'),
    patches.Patch(facecolor=colors['table'], edgecolor='black', label='Table'),
    patches.Patch(facecolor=colors['hand'], edgecolor='black', label='Hand Empty')
]
ax.legend(handles=legend_elements, loc='upper right', bbox_to_anchor=(1.15, 1))

# Set limits and remove axes
ax.set_xlim(0, 1)
ax.set_ylim(0, 0.6)
ax.axis('off')

# Save the figure
plt.savefig('blocksworld/one_shot/ini_diagram_code/attempts/attempt_20.png', bbox_inches='tight')
plt.show()